from fastapi import FastAPI, File, UploadFile
import aiofiles
import subprocess
import os

app = FastAPI()

OUTPUT_DIR = "uploads"
WEBM_FILE = os.path.join(OUTPUT_DIR, "recording.webm")  # Store full WebM
MP4_FILE = os.path.join(OUTPUT_DIR, "recording.mp4")  # Converted MP4

# Ensure upload directory exists
os.makedirs(OUTPUT_DIR, exist_ok=True)

@app.post("/upload")
async def upload_file(file: UploadFile = File(...)):
    #save FIle
    print(file.filename)
    # """Save the full recording as WebM (overwrite old one)."""
    # async with aiofiles.open(WEBM_FILE, "wb") as out_file:
    #     content = await file.read()
    #     await out_file.write(content)

    print(f"File saved as {WEBM_FILE}")
    return {"message": "File received", "filename": WEBM_FILE}


@app.get("/convert")
async def convert_to_mp4():
    """Convert WebM to MP4 with FFmpeg."""
    absolute_webm_path = os.path.abspath(WEBM_FILE)  # Get full path
    absolute_mp4_path = os.path.abspath(MP4_FILE)

    if not os.path.exists(absolute_webm_path):
        print(f"ERROR: {absolute_webm_path} NOT FOUND!")  # Debugging print
        return {"error": "No file found", "path": absolute_webm_path}

    print(f"✅ Found file: {absolute_webm_path}")  # Confirm file is found

    ffmpeg_cmd = [
        "/usr/bin/ffmpeg", "-y", "-i", absolute_webm_path, "-c:v", "libx264",
        "-preset", "fast", "-c:a", "aac", "-b:a", "128k", absolute_mp4_path
    ]

    result = subprocess.run(ffmpeg_cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)

    print(f"FFmpeg Output: {result.stdout}")
    print(f"FFmpeg Error: {result.stderr}")

    if result.returncode != 0:
        return {"error": "FFmpeg conversion failed", "details": result.stderr}

    print(f"✅ Converted to {absolute_mp4_path}")
    return {"message": "Conversion completed", "output": absolute_mp4_path}


if __name__ == "__main__":
    import uvicorn
    uvicorn.run(app, host="0.0.0.0", port=5000)
