import logging

class MeetingLogger:
    def __init__(self, name="meeting_logger"):
        self.logger = logging.getLogger(name)
        self.logger.setLevel(logging.INFO)

        if not self.logger.handlers:
            handler = logging.StreamHandler()
            formatter = logging.Formatter("[%(asctime)s] [%(levelname)s] %(message)s", "%Y-%m-%d %H:%M:%S")
            handler.setFormatter(formatter)
            self.logger.addHandler(handler)

    def log_info(self, meeting_id, message):
        self.logger.info(f"[{meeting_id}] {message}")

    def log_warning(self, meeting_id, message):
        self.logger.warning(f"[{meeting_id}] {message}")

    def log_error(self, meeting_id, message):
        self.logger.error(f"[{meeting_id}] {message}")

    def log_debug(self, meeting_id, message):
        self.logger.debug(f"[{meeting_id}] {message}")
