async def disable_popups(page):
    """
    Disable various JavaScript popups and dialog methods on the given Playwright page,
    auto-click any button with aria-label 'OK', and handle any errors gracefully.
    
    Disabled dialogs:
      - alert: Prevents pop-up messages.
      - confirm: Always returns true, simulating an "OK" click.
      - prompt: Returns null, simulating cancellation.
      - print: Disables print dialogs.
    
    Auto-click:
      - Searches for a button with aria-label 'OK' and clicks it if present.
    """
    try:
        # Disable popups
        await page.evaluate("""
            window.alert = function() {};
            window.confirm = function() { return true; };
            window.prompt = function() { return null; };
            window.print = function() {};
        """)
    except Exception as e:
        print(f"Error disabling popups: {e}")
    
    try:
        # Attempt to click a button with aria-label "OK"
        await page.evaluate("""
            var okButton = document.querySelector("button[aria-label='OK']");
            if (okButton) { okButton.click(); }
            """)

    except Exception as e:
        print(f"Error clicking OK button: {e}")
    

    