// Description: Background script for the extension

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    console.log("📩 Received message:", request);
    if (request.action === "requestTabID") {
        console.log("🔍 Requesting tab ID Started...");
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
            if (tabs.length > 0) {
                chrome.runtime.sendMessage({ action: "captureTabs", tabID: tabs[0].id });
            }
        });
    }
    if (request.action === "captureTabs" && request.tabId) {
        
        captureTabs(request.tabId, sendResponse);
        return true; // Keep async response open
    }
    // if (request.action === "requestTabIDX") {
    //     console.log("🔍 Requesting tab ID Started...");
        
    //     chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    //         console.log("🔍 Active Tab:", tabs);
    //         if (tabs.length > 0) {
    //             console.log("📌 Active Tab ID:", tabs[0].id);
                
    //             // 🔥 Send tab ID back to content.js
    //             sendResponse({ tabID: tabs[0].id });

    //             // 🔥 Send a separate message for "captureTabs"
    //         } else {
    //             sendResponse({ error: "No active tab found!" });
    //         }
    //     });

    //     return true; // ✅ Keeps the message port open for async response
    // }
});




function captureTabs(tabId, sendResponse) {
    chrome.tabs.get(tabId, (tab) => {
        if (chrome.runtime.lastError || !tab) {
            console.error("Error getting tab:", chrome.runtime.lastError?.message || "Tab not found");
            sendResponse({ success: false });
            return;
        }

        // Get media stream ID without user selection
        chrome.tabCapture.getMediaStreamId({consumerTabId: tabId}, (streamId) => {
            if (chrome.runtime.lastError || !streamId) {
                console.error("Failed to get stream ID:", chrome.runtime.lastError?.message || "Unknown error");
                sendResponse({ success: false });
                return;
            }

            // Inject content script before sending the stream ID
            chrome.scripting.executeScript({
                target: { tabId },
                files: ["content.js"]
            }, () => {
                if (chrome.runtime.lastError) {
                    console.error("Error injecting content script:", chrome.runtime.lastError.message);
                    sendResponse({ success: false });
                    return;
                }

                // Ensure content script is ready before sending message
                setTimeout(() => {
                    chrome.tabs.sendMessage(tabId, { action: "startCapture", streamId }, (response) => {
                        if (chrome.runtime.lastError) {
                            console.error("Error sending message:", chrome.runtime.lastError.message);
                            sendResponse({ success: false });
                            return;
                        }
                        sendResponse({ success: true });
                    });
                }, 100); // Short delay for content script readiness
            });
        });
    });
}
