console.log("✅ Content script injected!");


chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === "startCapture") {
        startCapture(request.streamId);
        sendResponse({ success: true }); // ✅ Always respond
    }
});
// document.addEventListener("keydown", (event) => {
//     if ((event.ctrlKey || event.metaKey) && event.shiftKey && event.code === "KeyS") {
//         chrome.runtime.sendMessage({ action: "requestTabID" });
//     }
// });


window.addEventListener("message", (event) => {
    console.log("📩 Received message from webpage:", event.data);

    if (event.data.type === "REQUEST_TAB_ID") {
        chrome.runtime.sendMessage({ action: "requestTabIDX" }, (response) => {
            if (chrome.runtime.lastError) {
                console.error("❌ Error:", chrome.runtime.lastError.message);
                return;
            }

            if (!response || !response.tabID) {
                console.error("❌ No tab ID received!");
                return;
            }

            const tabId = response.tabID;
            console.log("✅ Received tab ID:", tabId);
            chrome.runtime.sendMessage({ action: "captureTabs", tabId }, (response) => {
                console.log("📩 Received response from background:", response);
                if (response && response.success) {
                    console.log("✅ Captured stream with key:", response.streamKey);
                } else {
                    console.log("❌ Capture failed");
                }
            }
            );



            
        });
    }
});

function startCapture(streamId) {
    navigator.mediaDevices.getUserMedia({
        audio: {
            mandatory: {
                chromeMediaSource: "tab",
                chromeMediaSourceId: streamId
            }
        },
        video: {
            mandatory: {
                chromeMediaSource: "tab",
                chromeMediaSourceId: streamId
            }
        }
    }).then((stream) => {
        console.log("Started recording tab...");

        // ✅ Create MediaRecorder locally (no global vars)
        const recordedChunks = [];
        const mediaRecorder = new MediaRecorder(stream, { mimeType: "video/webm" });

        mediaRecorder.ondataavailable = (event) => {
            if (event.data.size > 0) recordedChunks.push(event.data);
        };

        mediaRecorder.onstop = () => saveRecording(recordedChunks);

        mediaRecorder.start(); // Start recording

        // ⏳ Stop and download after 10 seconds
        setTimeout(() => mediaRecorder.stop(), 60000);

        // Handle stream stop (if user closes tab)
        stream.getVideoTracks()[0].onended = () => {
            console.log("Stream stopped.");
            if (mediaRecorder.state !== "inactive") {
                mediaRecorder.stop();
            }
        };
    }).catch((err) => {
        console.error("Error capturing media:", err);
    });
}

// ✅ Function to Save Recording (No Global Variables)
function saveRecording(recordedChunks) {
    if (recordedChunks.length === 0) {
        console.error("No recorded data available.");
        return;
    }

    const blob = new Blob(recordedChunks, { type: "video/webm" });
    const url = URL.createObjectURL(blob);

    // Create a download link
    const a = document.createElement("a");
    a.href = url;
    a.download = `tab_recording_${Date.now()}.webm`;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);

    // Release memory
    URL.revokeObjectURL(url);
    console.log("Downloaded recording.");
}
