from fastapi import FastAPI, UploadFile, File
from fastapi.middleware.cors import CORSMiddleware
import os
import uuid
from datetime import datetime
import subprocess

app = FastAPI()

# CORS setup
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_methods=["*"],
    allow_headers=["*"],
)

CHUNK_DIR = "chunks"
MERGED_OUTPUT = "output.webm"
os.makedirs(CHUNK_DIR, exist_ok=True)

# @app.post("/upload_chunk")
# async def upload_chunk(chunk: UploadFile = File(...)):
#     timestamp = datetime.utcnow().strftime('%Y%m%d%H%M%S%f')
#     unique_name = f"{timestamp}_{uuid.uuid4().hex}.webm"
#     chunk_path = os.path.join(CHUNK_DIR, unique_name)

#     with open(chunk_path, "wb") as buffer:
#         buffer.write(await chunk.read())

#     return {"status": "chunk received", "filename": unique_name}


# @app.post("/merge_chunks")
# def merge_chunks():
#     chunks = sorted(f for f in os.listdir(CHUNK_DIR) if f.endswith(".webm"))
#     if not chunks:
#         return {"error": "No chunks found"}

#     list_path = os.path.join(CHUNK_DIR, "file_list.txt")
#     with open(list_path, "w") as f:
#         for chunk in chunks:
#             f.write(f"file '{os.path.abspath(os.path.join(CHUNK_DIR, chunk))}'\n")

#     output_path = os.path.abspath("output.mp4")

#     try:
#         subprocess.run([
#             "ffmpeg", "-f", "concat", "-safe", "0",
#             "-i", list_path,
#             "-c", "copy",
#             output_path
#         ], check=True)
#         return {"status": "merged", "file": "output.mp4"}
#     except subprocess.CalledProcessError as e:
#         return {"error": "FFmpeg failed", "details": str(e)}
# if __name__=="__main__":
#     import uvicorn
#     uvicorn.run(app=app)

# from pydub import AudioSegment

# # Path to the WebM chunk
# webm_path = r"C:\Users\ssenp\Downloads\5148bce6e0c8f65b411266a9171e5ddf791fb2d8a782c06c03703679af78edb4_chunk_1.webm"

# output_path = "fixed.wav"

# subprocess.run([
#     "ffmpeg", "-fflags", "+genpts", "-i", webm_path,
#     "-acodec", "pcm_s16le", "-ar", "16000", "-ac", "1", output_path
# ], check=True)

# import requests

# url = "http://10.0.0.3:15000/meetmemo-assets/v2/recordings/6c91fa33516de2539901f02a6e2e000cf78c4e0d5054c2a5162f4f675bc146ae/contributors_button-view.html"
# response = requests.get(url)

# with open("contributors_button-view.html", "wb") as f:
#     f.write(response.content)

# print("Downloaded successfully.")


from vertexai.generative_models import GenerativeModel, Tool, FunctionDeclaration, Content, Part
import vertexai
from google.oauth2 import service_account

# Define your function
def get_weather(city: str) -> str:
    return f"The weather in {city} is sunny and 28°C."

# Define the function schema for Gemini
weather_function = FunctionDeclaration(
    name="get_weather",
    description="Returns weather information for a given city.",
    parameters={
        "type": "object",
        "properties": {
            "city": {
                "type": "string",
                "description": "Name of the city to get the weather for"
            }
        },
        "required": ["city"]
    },
)

# Register the tool with Gemini
weather_tool = Tool(function_declarations=[weather_function])
PROJECT_ID = "meet-memo-transcription"  # or your actual project ID
LOCATION = "us-central1"  # or another supported region
credentials = service_account.Credentials.from_service_account_file(
    r"C:\Users\ssenp\projects\meetmemo\meetmemo-bot-v2\bot-main\build-assets\vertex-credentials.json"
)
vertexai.init(project=PROJECT_ID, location=LOCATION,    credentials=credentials)

# Define your tool (assuming you already defined `weather_tool` and `get_weather`)
model = GenerativeModel(
    model_name="gemini-2.0-flash-001",
    tools=[weather_tool]
)

# Step 1: Initial user prompt wrapped properly in Content
response = model.generate_content(
    contents=[Content(role="user", parts=[Part.from_text("What's the weather in Mumbai?")])],
    generation_config={
        "temperature": 0.7
    },
)

# Step 2: Handle function call
for part in response.candidates[0].content.parts:
    if hasattr(part, "function_call"):
        func_call = part.function_call
        print(f"Gemini wants to call: {func_call.name}")
        print(f"With arguments: {func_call.args}")

        # Call your actual function
        result = get_weather(**func_call.args)
        print("Function result:", result)
 
        # Step 3: Send result back using role="function"
        followup = model.generate_content([
                response.candidates[0].content,
                Content(
                    role="function",
                    parts=[
                        Part.from_function_response(
                            name=func_call.name,
                            response={"result": result}
                        )
                    ]
                ),
                Content(
                    role="user",
                    parts=[
                        Part.from_text("Okay, go ahead.")
                    ]
                )
            ])



        print("Gemini follow-up:", followup.text)

    else:
        # No function call, just plain response
        print("Gemini response:", part.text)
