import asyncio,shutil,tempfile,os,logging
import nodriver as uc
from fastapi import FastAPI
from google_meet import googlemeet
import uuid
from fastapi import FastAPI,UploadFile,File
from datetime import datetime
from fastapi.middleware.cors import CORSMiddleware
from fastapi.middleware.trustedhost import TrustedHostMiddleware
from starlette.responses import Response



logging.basicConfig(level=logging.INFO)
logger = logging.getLogger("async_logger")


app = FastAPI()
# Allow all origins, methods, and headers (or restrict as needed)
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],  # Replace "*" with specific origins if needed
    allow_credentials=True,
    allow_methods=["*"],  # Allows all HTTP methods
    allow_headers=["*"],  # Allows all HTTP headers
    expose_headers=["Access-Control-Allow-Private-Network"],  # Important!

)
app.add_middleware(TrustedHostMiddleware, allowed_hosts=["*"])

# Chrome flags for a headless, optimized session
CHROME_FLAGS = [
    "--disable-notifications",
    # "--use-fake-ui-for-media-stream",
    "--use-fake-device-for-media-stream",
    "--window-size=1920x1080",
    "--disable-gpu",
    # "--disable-extensions",
    "--disable-application-cache",
    "--disable-dev-shm-usage",
    # "--incognito",
    "--disable-infobars",
    "--allow-file-access-from-files",
    # "--disable-gesture-requirement-for-media-playback",
    "--enable-features=WebRTC-H264WithOpenH264FFmpeg",
    "--no-sandbox",
    "--disable-software-rasterizer",
    "--disable-background-networking",
    "--disable-background-timer-throttling",
    "--disable-backgrounding-occluded-windows",
    "--disable-breakpad",
    "--disable-component-update",
    "--disable-domain-reliability",
    "--disable-features=Translate,BackForwardCache,WebRtcHideLocalIpsWithMdns",
    "--disable-ipc-flooding-protection",
    "--disable-renderer-backgrounding",
    "--disable-sync",
    "--metrics-recording-only",
    "--enable-experimental-web-platform-features",
    # "--auto-open-devtools-for-tabs",
    "--disable-extensions-file-access-check",
    "--disable-blink-features=AutomationControlled"
    # "--mute-audio",
    # '--url="http://localhost:5000"',
    ,"--no-first-run"
    ,"--no-default-browser-check",
    "--disable-features=BlockInsecurePrivateNetworkRequests",
    "--disable-features=block-insecur-private-network-requests"
    
]

class NoDriverBrowser:
    def __init__(self):
        self.browser = None
        self.all_pages = {}


    async def start(self):
        """Start the browser instance if not already running."""
        if not self.browser:
            extension_folder = "tab_extension" #to get in localhost
            # extension_folder = "tab_extension_d" # save in download popup
            # Create a unique user data directory
            temp_user_data_dir = tempfile.mkdtemp()
            user_profile_folder = "user_profile"
            shutil.copytree(user_profile_folder, temp_user_data_dir, dirs_exist_ok=True)  # Copy profile
            # temp_user_data_dir=user_profile_folder
            video_file="dynamic.y4m"
            # Check if the file exists
            if os.path.exists(video_file):
                print("✅ The file exists.")
            else:
                print("❌ The file does not exist.")

            # User agents to rotate
            CHROME_FLAGS.append(f'--use-file-for-fake-video-capture={os.path.abspath(video_file)}')
            # CHROME_FLAGS.append(f'--disable-extensions-except={os.path.abspath(extension_folder)}')
            # CHROME_FLAGS.append(f'--disable-extensions-except={os.path.abspath(extension_folder)}',)
            CHROME_FLAGS.append(f'--load-extension={os.path.abspath(extension_folder)}')
            CHROME_FLAGS.append(f"--user-data-dir={os.path.abspath(temp_user_data_dir)}")  # Windows example
            self.browser = await uc.start(browser_args=CHROME_FLAGS)

    async def get(self, url: str,meeting_id=uuid.uuid4().hex, new_tab=True):
        """Open a URL in an existing browser session."""
        await self.start()
        # if self.all_pages.__len__()==0:
        #     print("First Page")
        #     page=await self.browser.get(url, new_tab=True)
        #     await asyncio.sleep(5)
        # else:
        page=await self.browser.get(url, new_tab=True)
        self.all_pages[meeting_id]=page
        await page.maximize()
        if "google" in url:
            await googlemeet(page=page,mainurl=url)

        page.close()
        
    async def close_page(self, meeting_id):
        """Close a specific page."""
        if meeting_id in self.all_pages:
            page = self.all_pages.pop(meeting_id)
            await page.close()

    async def close(self):
        """Close the browser instance."""
        if self.browser:
            for page in list(self.all_pages.values()):
                await page.close()
            self.all_pages.clear()
            await self.browser.close()
            self.browser = None


# Global browser instance
browser = NoDriverBrowser()
UPLOAD_DIR = "recordings"  # Ensure it matches the Docker mount path


@app.options("/upload_video/")
async def preflight(response: Response):
    response.headers["Access-Control-Allow-Origin"] = "https://meet.google.com"
    response.headers["Access-Control-Allow-Methods"] = "POST, OPTIONS"
    response.headers["Access-Control-Allow-Headers"] = "*"
    response.headers["Access-Control-Allow-Private-Network"] = "true"  # ✅ Important!
    return response

@app.on_event("startup")
async def on_startup():
    """Start the browser automatically when the server starts."""
    await browser.start()

@app.get("/open_tab/")
async def open_tab(url: str):
    """API endpoint to open a new tab with the given URL."""
    try:
        # asyncio.create_task()
        # page = await browser.get(url)
        asyncio.create_task(browser.get(url))  # Open in a new tab asynchronously

        return {"status": "success", "message": f"Opened {url} in a new tab"}
    except Exception as e:
        return {"status": "error", "message": str(e)}

@app.get("/close_browser/")
async def close_browser():
    """API endpoint to close the browser."""
    await browser.close()
    return {"status": "success", "message": "Browser closed"}

@app.get("/close_page/")
async def close_page(meeting_id: str):
    await browser.close_page(meeting_id)
    return {"status": "success", "message": "Page closed"}

@app.get("/browser_current_pages/")
async def browser_current_pages():
    return {"status": "success", "message": list(browser.all_pages.keys())}

@app.post("/upload_video/")
async def upload_video(file: UploadFile = File(...)):
    logger.info("Upload_Comed")
    timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
    file_path = os.path.join(os.path.abspath(UPLOAD_DIR), f"{timestamp}_{file.filename}")

    with open(file_path, "wb") as buffer:
            shutil.copyfileobj(file.file, buffer)  # Efficient file saving

    return {"status": "success", "saved_as": file_path}

if __name__ == "__main__":
    import uvicorn
    uc.loop().run_until_complete(uvicorn.run(app, host="0.0.0.0", port=8000))
