import asyncio
import logging
# logging logger
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger("async_logger")

async def wait_for_page_load(page, timeout=30):
    """Waits for the page to fully load by checking the document state."""
    start_time = asyncio.get_event_loop().time()
    running=True
    # First loop: Wait for "interactive" state (initial page load)
    while running:
        try:
            ready_state = await page.evaluate("document.readyState;")
            if ready_state in ["interactive", "complete"]:
                logger.info("Page reached 'interactive' state.")
                running=False
                break  # Move to next phase
        except Exception as e:
            logger.info(f"Error checking page state: {e}")

        if asyncio.get_event_loop().time() - start_time > timeout:
            logger.info("Timeout reached while waiting for 'interactive' state.")
            running=False
            return

        await asyncio.sleep(0.5)

    # Second loop: Ensure page reaches "complete" state before proceeding
    running2=True
    while running2:
        try:
            ready_state = await page.evaluate("document.readyState;")
            if ready_state == "complete":
                logger.info("Page fully loaded.")
                running2=False
                return
        except Exception as e:
            logger.info(f"Error checking page state: {e}")

        if asyncio.get_event_loop().time() - start_time > timeout:
            logger.info("Timeout reached while waiting for 'complete' state.")
            running2=False
            return

        await asyncio.sleep(0.5)