// document.getElementById("captureBtn").addEventListener("click", () => {
//     chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
//         if (tabs.length === 0) {
//             console.error("No active tab found");
//             return;
//         }

//         const tabId = tabs[0].id; // Get the active tab's ID

//         chrome.runtime.sendMessage({ action: "captureTabs", tabId }, (response) => {
//             if (response && response.success) {
//                 console.log("Captured stream with key:", response.streamKey);
//             } else {
//                 console.log("Capture failed");
//             }
//         });
//     });
// });

// document.addEventListener("DOMContentLoaded", () => {
//     setTimeout(() => {
//         chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
//             if (tabs.length === 0) {
//                 console.error("No active tab found");
//                 return;
//             }

//             const tabId = tabs[0].id; // Get active tab ID

//             chrome.runtime.sendMessage({ action: "captureTabs", tabId }, (response) => {
//                 if (response && response.success) {
//                     console.log("Captured stream with key:", response.streamKey);
//                 } else {
//                     console.log("Capture failed");
//                 }
//             });
//         });
//     }, 5000); // Delay execution by 5 seconds
// });

document.addEventListener("DOMContentLoaded", () => {
    const captureBtn = document.getElementById("captureBtn");

    // Function to capture the active tab
    function captureActiveTab() {
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
            if (tabs.length === 0) {
                console.error("No active tab found");
                return;
            }

            const tabId = tabs[0].id; // Get the active tab's ID

            chrome.runtime.sendMessage({ action: "captureTabs", tabId }, (response) => {
                if (response && response.success) {
                    console.log("Captured stream with key:", response.streamKey);
                } else {
                    console.log("Capture failed");
                }
            });
        });
    }

    // Auto-click (trigger capture)
    captureActiveTab();

    // If user manually clicks the button, capture again
    captureBtn.addEventListener("click", captureActiveTab);
});
