import time
import nodriver as uc
import  random
import os,json
import tempfile,shutil


# Chrome flags for a headless, optimized session
CHROME_FLAGS = [
    "--disable-notifications",
    # "--use-fake-ui-for-media-stream",
    "--use-fake-device-for-media-stream",
    "--window-size=1920x1080",
    "--disable-gpu",
    # "--disable-extensions",
    "--disable-application-cache",
    "--disable-dev-shm-usage",
    # "--incognito",
    "--disable-infobars",
    "--allow-file-access-from-files",
    # "--disable-gesture-requirement-for-media-playback",
    "--enable-features=WebRTC-H264WithOpenH264FFmpeg",
    "--no-sandbox",
    "--disable-software-rasterizer",
    "--disable-background-networking",
    "--disable-background-timer-throttling",
    "--disable-backgrounding-occluded-windows",
    "--disable-breakpad",
    "--disable-component-update",
    "--disable-domain-reliability",
    "--disable-features=Translate,BackForwardCache,WebRtcHideLocalIpsWithMdns",
    "--disable-ipc-flooding-protection",
    "--disable-renderer-backgrounding",
    "--disable-sync",
    "--metrics-recording-only",
    "--enable-experimental-web-platform-features",
    # "--auto-open-devtools-for-tabs",
    "--disable-extensions-file-access-check",
    "--disable-blink-features=AutomationControlled"
    # "--mute-audio",
    # '--url="http://localhost:5000"',
    ,"--no-first-run"
    ,"--no-default-browser-check"
    
]


async def start_browser(proxy_url=None):
    # Path to the video file
    # video_file = os.path.join(os.path.curdir, "/dynamic.y4m")
    extension_folder = "tab_extension"
    # Create a unique user data directory
    temp_user_data_dir = tempfile.mkdtemp()
    user_profile_folder = "user_profile"
    shutil.copytree(user_profile_folder, temp_user_data_dir, dirs_exist_ok=True)  # Copy profile

    video_file="dynamic.y4m"
    # Check if the file exists
    if os.path.exists(video_file):
        print("✅ The file exists.")
    else:
        print("❌ The file does not exist.")

    # User agents to rotate
    CHROME_FLAGS.append(f'--use-file-for-fake-video-capture={os.path.abspath(video_file)}')
    # CHROME_FLAGS.append(f'--disable-extensions-except={os.path.abspath(extension_folder)}')
    # CHROME_FLAGS.append(f'--disable-extensions-except={os.path.abspath(extension_folder)}',)
    CHROME_FLAGS.append(f'--load-extension={os.path.abspath(extension_folder)}')
    CHROME_FLAGS.append(f"--user-data-dir={os.path.abspath(temp_user_data_dir)}")  # Windows example
    # CHROME_FLAGS.append(f"--user-data-dir={os.path.abspath(user_profile_folder)}")  # Windows example
    # CHROME_FLAGS.append(f"--profile-directory=Profile 1")# Change this if using a different profile
    
    # CHROME_FLAGS.append(f'--disable-features=ExtensionsToolbarMenu')

    # Pick a random user agent
    if proxy_url:
        CHROME_FLAGS.append(f'--proxy-server={proxy_url}')
    
    browserfail = 0
    while True:
        try:
            #browser = await uc.start(browser_args=browser_args, user_data_dir="/botprofile/" + config["meetmemo_id"] + "/profilepath", expert=True)
            browser = await uc.start(browser_args=CHROME_FLAGS, expert=True,sandbox=False)
            await browser.grant_all_permissions()
            return browser
        except Exception as e:
            time.sleep(2)
            print(f"Error: {e}")
            browserfail += 1
            if browserfail > 5:
                print("Browser failed 5 times, exiting")
                exit()
            continue


