import re
from string import Template

# Helper to convert {{key}} to $key
def convert_to_template_string(text):
    return re.sub(r"\{\{(\w+)\}\}", r"$\1", text)
# Template configuration store
TEMPLATE_CONFIGS = {
    "Free Moment Delivery - Template 1": {
        "subject": "This one’s free. Unlock the rest for {{price}}.",
        "body": """Hey there,

        Here’s the moment you captured from {{podcast_name}} – {{episode_title}}.

        This one's on us ;)

        You’ve just used Podcast Magic. No app. No logins. No subscriptions. No BS.
        Pay once, use forever → Get unlimited moments for {{price}}

        Moment

        {{moment_title}}

        Timestamp

        {{start_time}} – {{end_time}}

        Sharable moment

        Share as a video

        Transcript

        {{transcript_text}}

        Want the related rabbit holes too?

        Try Sublime — the tool for saving what inspires you and discovering unexpected connections.

        —
        The Podcast Magic team

        Need help? View FAQ & Support Guide
        Something broken? Report an issue"""
        
    }
}


def render_template(template_name: str, values: dict):
    config = TEMPLATE_CONFIGS.get(template_name)
    if not config:
        raise ValueError(f"Template '{template_name}' not found.")
    required_params = get_template_params(template_name)

    missing_keys = [k for k in required_params if k not in values]
    if missing_keys:
        raise ValueError(f"Missing values for: {missing_keys}")

    subject_template = Template(convert_to_template_string(config["subject"]))
    body_template = Template(convert_to_template_string(config["body"]))
    

    subject = subject_template.safe_substitute(values)
    body = body_template.safe_substitute(values)

    return {
        "subject": subject,
        "body": body
    }

def extract_params_from_text(text: str):
    return sorted(set(re.findall(r"\{\{(\w+)\}\}", text)))

# Get required params for a template
def get_template_params(template_name: str):
    config = TEMPLATE_CONFIGS.get(template_name)
    if not config:
        raise ValueError(f"Template '{template_name}' not found.")

    subject_params = extract_params_from_text(config['subject'])
    body_params = extract_params_from_text(config['body'])

    # Combine and return unique param names
    return sorted(set(subject_params + body_params))
# required = get_template_params("Free Moment Delivery - Template 1")
# print(required)

# # Example use
values = {
    "podcast_name": "CodeTalk",
    "episode_title": "AI & the Future",
    "price": "$9.99",
    "moment_title": "AI Ethics",
    "start_time": "10:02",
    "end_time": "11:15",
    "transcript_text": "AI is changing everything..."
}

filled = render_template("Free Moment Delivery - Template 1", values)
print(filled)




