import asyncio
import nodriver as uc
from disablepopup import disable_popups
from waitpageload import wait_for_page_load
import time
import re
import pyautogui
import logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger("async_logger")


from util import normalize_username, should_skip_participant
# import psutil



# Load the configuration
config = {
    "meet_user_name": "Test Bot",
    "meet_notification_message": "Hello everyone, I am a bot. Please ignore me.",
    "meet_status": "running"
}
def status_update(key, value):
    print(f"Status updated: {key} -> {value}")




async def parse_participants_google_meet(page, all_participants_html_dict, all_participants_each_state_html_dict, compbotnames):
        """Parse meeting participants for google meet domain."""
        # soup = BeautifulSoup(html_content, 'html.parser')
        participant_elements = await page.query_selector_all("div[role='list'][aria-label='Participants'] > div[role='listitem']")

        #Check Entire Participants List
        participant_elements_str=str(participant_elements)
        if participant_elements_str in all_participants_html_dict:
            return all_participants_html_dict[participant_elements_str]
        else:
            participants = []
            for participant_ele in participant_elements:
                #Check Entire Participants wise List
                participant_ele_str=str(participant_ele)
                # if participant_ele_str in all_participants_each_state_html_dict.keys():
                if participant_ele_str in all_participants_each_state_html_dict:
                    # If the participant element is found, skip it
                    participant_info_data=all_participants_each_state_html_dict[participant_ele_str]
                    participants.append(participant_info_data)
                else:
                    # print("Participant Element:",participant_ele)
                    participant_info={
                        "name": "",
                        "role": "user",
                        "audio_state": "muted"

                    }
                    name=""
                    role="user"
                    audio_state="muted"
                    try:
                        # Extract participant name
                        name_element = await participant_ele.query_selector("div[role='listitem'] span")
                        print("Name Element:",name_element.text)
                        if name_element:
                            name = name_element.text
                            name = re.sub(r'\s+', ' ', name.strip()) if name else ""
                        else:
                            name = ""

                        participant_info["username"] = name
                    except Exception as e:
                        print(e,"NameErr...")
                    username = normalize_username(name)
                    if not username or should_skip_participant(username, compbotnames):
                        continue
                    try:
                        # Extract role (e.g., Organizer)
                        is_you = await participant_ele.query_selector('span.NnTWjc')
                        if is_you:
                            role = "bot"
                        else:
                            role_div = await participant_ele.query_selector('div.qrLqp')
                            if role_div:
                                role_text =role_div.text.strip().lower()
                                if "meeting host" in role_text:
                                    role = "host"
                                elif role_text == "presentation":
                                    role = "presentation"
                                elif role_text == "(you)":
                                    role = "bot"
                                else:
                                    role = "user"
                        if not role:
                            if username ==config["meet_user_name"]:
                                role = "bot"


                        participant_info["role"]=role
                    except Exception as e:
                        print(e,"roleErr...")
                    try:
                        # Check Audio State (Muted, Unmuted, or Speaking)
                        muted_div = await participant_ele.query_selector('div.FTMc0c')
                        status_div = await participant_ele.query_selector('div.IisKdb.GF8M7d')
                        if muted_div:
                            audio_state = "muted"
                        
                        elif status_div:
                            status_html = await status_div.get_html() if status_div else ""
                            # Define speaking indicators (including uppercase variations)
                            speaking_indicators = {"0aajhc", "Oaajhc", "wEsLMd", "WEsLMd", "HX2H7", "0gVli", "OgVli"}

                            if any(indicator in status_html for indicator in speaking_indicators):
                                audio_state = "speaking"
                            elif "gjg47c" in status_html:
                                audio_state = "not_speaking"
                            else:
                                audio_state = "not_speaking"
                        else:
                            audio_state = "not_speaking"

                        participant_info["audio_state"] = audio_state

                    except Exception as e:
                        print(f"Error detecting audio state: {e}")

                    participants.append(participant_info)
                    all_participants_each_state_html_dict[participant_ele_str]=participant_info
        all_participants_html_dict[participant_elements_str]=participants
        return participants


# await page.evaluate("""
#     chrome.runtime.sendMessage('ghdgghagbddigjabpolhbijgjcdhpgbd', { action: 'requestTabID' });
# """)
# await page.evaluate("""    window.postMessage({ type: "REQUEST_TAB_ID" }, "*");""")


async def googlemeet(page:uc.Tab,mainurl:str):
    await wait_for_page_load(page=page)
    await disable_popups(page)
    max_retries = 5
    attempts = 0

    while attempts < max_retries:
        attempts += 1
        try:
            await page.wait_for(text="Ask to join", timeout=10)
            print("Recording Initiated start...")
            await page.bring_to_front()
            pyautogui.hotkey('alt', 'shift', 'c')
            print("Recording Initiated cmplt...")
            
            bot_name = await page.select("input[type=text]")
            if bot_name:
                print(bot_name)
                await bot_name.send_keys(config["meet_user_name"])
            else:
                print("Botname not found")
                continue
            


            
            mic_button = await page.select("div[aria-label='Turn off microphone']")
            await mic_button.click()
            
            ask_button = await page.find(text="Ask to join")
            await ask_button.click()
            await asyncio.sleep(2)
            
            # Check if blocked from joining
            you_cannot = await page.find_element_by_text(text="You can't join this video call")
            if not you_cannot:
                print("Corrected Page Found")
                break  # Exit loop if successfully joined
            
        except Exception as e:
            print(f"Attempt {attempts} failed: {e}")
        
        # If blocked, reload and retry
        if attempts < max_retries:
            page = await page.get(url=mainurl)
            await wait_for_page_load(page=page)
            await disable_popups(page)


    # Open participants panel
    max_wait_min_time = 60*15
    print("People button waiting")
    people_button = await page.wait_for(text="People",timeout=max_wait_min_time)
    print("Reached...")
    print("People button found")
    await asyncio.sleep(2)
    try:
        chat_button = await page.select(selector='button[aria-label="Chat with everyone"]')
        await chat_button.click()
        text_area = await page.select(selector='textarea[aria-label="Send a message to everyone"]')
        await text_area.send_keys(config["meet_notification_message"])
        send_button = await page.select(selector='button[aria-label="Send a message to everyone"]')
        await send_button.click()
    except Exception as e:
        print("Error sending notification message", e)
    print("People button clicking...")
    # Find the "People" button using its aria-label
    people_button = await page.query_selector("button[aria-label='People']")

    # Ensure the button is found before clicking
    if people_button:
        await people_button.click()
    else:
        print("People button not found!")

    print("People button clicked")
    await asyncio.sleep(2)
    print("Contributors")
    await page.wait_for(text="Contributors",timeout=10)

    meeting_end_conditions = {
                "You've been removed from the meeting": "bot_removed",
                "You left the meeting": "bot_left",
                "The call ended because everyone left": "meeting_ended",
                "This meeting has ended": "meeting_ended",
                "The video call ended because of a server error": "bot_left",
                "a server error": "bot_left",
            }
    all_participants_each_state_html_dict={}
    all_participants_html_dict={}
    compbotnames = set()
    # Initialize tracking variables
    participants_info = {}
    participants_current_state = {}
    start_time = time.time()
    last_activity_time = time.time()
    INACTIVE_TIMEOUT = 15 * 60
    REFRESH_INTERVAL = 0.2
    try:
        
        while True:
            status = await page.evaluate('''
                (["You've been removed from the meeting", 
                "You left the meeting", 
                "The call ended because everyone left", 
                "This meeting has ended", 
                "The video call ended because of a server error", 
                "a server error"]
                ).find(msg => document.body.innerText.includes(msg)) || null;
            ''')

            
            if status:
                print(status)
                # Inject the function into the page
                status_update("meet_status", meeting_end_conditions[status])
                break
            current_time = time.time()

            all_muted = True
            current_usernames = set()
            # Get participant HTML content
            try:
                participants = await page.select("div[aria-label='Participants']")
            except:
                print("Participants not found")
                continue
            participant_html = str(participants)

            if participant_html in all_participants_each_state_html_dict.keys():
                participant_all=all_participants_each_state_html_dict[participant_html]
            else:
                # Parse participant info using BeautifulSoup
                participant_all = await parse_participants_google_meet(page, all_participants_html_dict, all_participants_each_state_html_dict, compbotnames)
                all_participants_html_dict[participant_html]=participant_all
            
            for participant in participant_all:
                # print("PARSED INFO", participant)
                if not participant['username']:
                    continue
                username = normalize_username(participant['username'])
                role = participant['role']
                current_status = participant['audio_state']
                current_usernames.add(username)
                
                # Skip bots and presentations
                if role in ['bot', 'presentation'] or username in compbotnames:
                    continue
                
                
                # Update activity tracking
                if current_status in ['speaking', 'not_speaking']:
                    all_muted = False
                    last_activity_time = current_time
                
                # Handle participant state tracking
                if username not in participants_info:
                    # New participant
                    participants_info[username] = {
                        "participant": username,
                        "role": role,
                        "speaking_timestamps": []
                    }
                    participants_current_state[username] = {
                        "role": role,
                        "status": current_status,
                        "start_time": time.time() - start_time
                    }
                elif username not in participants_current_state:
                    # Participant rejoined
                    participants_current_state[username] = {
                        "role": role,
                        "status": current_status,
                        "start_time": time.time() - start_time
                    }
                    participants_info[username]["speaking_timestamps"].append({
                        "from": time.time() - start_time,
                        "to": time.time() - start_time,
                        "status": "rejoined"
                    })
                else:
                    # Update existing participant
                    if participants_current_state[username]["role"] != role:
                        participants_info[username]["role"] = role
                        participants_current_state[username]["role"] = role
                    
                    old_status = participants_current_state[username]["status"]
                    if old_status != current_status:
                        participants_info[username]["speaking_timestamps"].append({
                            "from": participants_current_state[username]["start_time"],
                            "to": time.time() - start_time,
                            "status": old_status
                        })
                        participants_current_state[username]["start_time"] = time.time() - start_time
                        participants_current_state[username]["status"] = current_status
                
                
    # Handle participants that left
            usernames_to_remove = []
            for user in participants_current_state:
                if user not in current_usernames:
                    try:
                        old_status = participants_current_state[user]["status"]
                        participants_info[user]["speaking_timestamps"].append({
                            "from": participants_current_state[user]["start_time"],
                            "to": time.time() - start_time,
                            "status": old_status
                        })
                        participants_info[user]["speaking_timestamps"].append({
                            "from": time.time() - start_time,
                            "to": time.time() - start_time,
                            "status": "left"
                        })
                        usernames_to_remove.append(user)
                        print(f"Participant {user} left the meeting")
                    except Exception as e:
                        print(f"Error marking participant left {user}: {e}")
            
            for user in usernames_to_remove:
                del participants_current_state[user]
            
            # Check for inactivity
            if current_time - last_activity_time > INACTIVE_TIMEOUT and all_muted:
                print("Meeting inactive for 15 minutes")
                # Inject the function into the page
                status_update("meet_status", "bot_left")
                
                break
            # Check if bot is alone
            if len(current_usernames) == 1:
                print("Bot alone in meeting")
                if not hasattr(googlemeet, '_alone_start_time'):
                    googlemeet._alone_start_time = current_time
                elif current_time - googlemeet._alone_start_time > INACTIVE_TIMEOUT:
                    print("Bot alone in meeting for 15 minutes")
                    # Inject the function into the page
                    status_update("meet_status", "bot_left")
                    break
            else:
                if hasattr(googlemeet, '_alone_start_time'):
                    delattr(googlemeet, '_alone_start_time')
    except asyncio.CancelledError:
        print("Closing browser...")
        # monitor_task.cancel()  # Stop monitoring

