import uvicorn
import subprocess
from fastapi import FastAPI,UploadFile,File
from fastapi.middleware.cors import CORSMiddleware
from fastapi.middleware.trustedhost import TrustedHostMiddleware

import os
from datetime import datetime
import logging
import shutil
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger("async_logger")


app = FastAPI()

# Allow all origins, methods, and headers (or restrict as needed)
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],  # Replace "*" with specific origins if needed
    allow_credentials=True,
    allow_methods=["*"],  # Allows all HTTP methods
    allow_headers=["*"],  # Allows all HTTP headers
)
app.add_middleware(TrustedHostMiddleware, allowed_hosts=["*"])

# Store running processes (task_id → process object)
running_tasks = {}

# UPLOAD_DIR = "/app/recordings"  # Ensure it matches the Docker mount path
UPLOAD_DIR = "recordings"  # Ensure it matches the Docker mount path
# os.makedirs(UPLOAD_DIR, exist_ok=True)

@app.get("/")
def read_root():
    return {"message": "FastAPI server is running inside Pipenv!"}


@app.post("/upload_video/")
async def upload_video(file: UploadFile = File(...)):
    logger.info("Upload_Comed")
    timestamp = datetime.now().strftime("%Y%m%d_%H%M%S")
    file_path = os.path.join(os.path.abspath(UPLOAD_DIR), f"{timestamp}_{file.filename}")

    with open(file_path, "wb") as buffer:
            shutil.copyfileobj(file.file, buffer)  # Efficient file saving

    return {"status": "success", "saved_as": file_path}
# Start a new process
@app.post("/start_task/")
def start_task(task_id: int):
    if task_id in running_tasks:
        return {"status": "error", "message": "Task already running"}

    # Start `nodrivertest.py` inside Pipenv
    process = subprocess.Popen(["pipenv", "run", "python", "nodrivertest.py", str(task_id)])

    # Store the running process
    running_tasks[task_id] = process

    return {"status": "success", "task_id": task_id, "pid": process.pid}

# Stop a running process
@app.post("/stop_task/")
def stop_task(task_id: int):
    if task_id not in running_tasks:
        return {"status": "error", "message": "Task not found"}

    # Kill the process
    running_tasks[task_id].terminate()
    del running_tasks[task_id]

    return {"status": "success", "message": f"Task {task_id} stopped"}

# List all running tasks
@app.get("/list_tasks/")
def list_tasks():
    return {"running_tasks": list(running_tasks.keys())}

# Start the FastAPI server
if __name__ == "__main__":
    uvicorn.run(app, host="0.0.0.0", port=9000)
