console.log("✅ Content script injected!");


chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === "startCapture") {
        startCapture(request.streamId);
        sendResponse({ success: true }); // ✅ Always respond
    }
});
// document.addEventListener("keydown", (event) => {
//     if ((event.ctrlKey || event.metaKey) && event.shiftKey && event.code === "KeyS") {
//         chrome.runtime.sendMessage({ action: "requestTabID" });
//     }
// });


window.addEventListener("message", (event) => {
    console.log("📩 Received message from webpage:", event.data);

    if (event.data.type === "REQUEST_TAB_ID") {
        chrome.runtime.sendMessage({ action: "requestTabIDX" }, (response) => {
            if (chrome.runtime.lastError) {
                console.error("❌ Error:", chrome.runtime.lastError.message);
                return;
            }

            if (!response || !response.tabID) {
                console.error("❌ No tab ID received!");
                return;
            }

            const tabId = response.tabID;
            console.log("✅ Received tab ID:", tabId);
            chrome.runtime.sendMessage({ action: "captureTabs", tabId }, (response) => {
                console.log("📩 Received response from background:", response);
                if (response && response.success) {
                    console.log("✅ Captured stream with key:", response.streamKey);
                } else {
                    console.log("❌ Capture failed");
                }
            }
            );



            
        });
    }
});

function startCapture(streamId) {
    navigator.mediaDevices.getUserMedia({
        audio: {
            mandatory: {
                chromeMediaSource: "tab",
                chromeMediaSourceId: streamId
            }
        },
        video: {
            mandatory: {
                chromeMediaSource: "tab",
                chromeMediaSourceId: streamId
            }
        }
    }).then((stream) => {
        console.log("Started recording tab...");

        const mediaRecorder = new MediaRecorder(stream, { mimeType: "video/webm" });
        let chunkCount = 1; // Track chunk number

        mediaRecorder.ondataavailable = async (event) => {
            if (event.data.size > 0) {
                await uploadChunk(event.data, chunkCount);
                chunkCount++;
            }
        };

        mediaRecorder.start(20000); // Capture chunks every 20 seconds

        // ⏳ Stop after 1 minute
        setTimeout(() => mediaRecorder.stop(), 60000);

        // Stop recording if the tab is closed
        stream.getVideoTracks()[0].onended = () => {
            console.log("Stream stopped.");
            if (mediaRecorder.state !== "inactive") {
                mediaRecorder.stop();
            }
        };
    }).catch((err) => {
        console.error("Error capturing media:", err);
    });
}

async function uploadChunk(blob, chunkCount) {
    const formData = new FormData();
    formData.append("file", blob, `chunk_${chunkCount}.webm`); // Ensure "file" is the correct key

    try {
        const response = await fetch("http://localhost:8000/upload_video/", {
            method: "POST",
            body: formData,
            headers: {
                "Accept": "application/json",
                "Access-Control-Allow-Private-Network": "true",  // Required for private networks

            }
        });

        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }

        const data = await response.json();
        console.log("Chunk uploaded:", data);
    } catch (error) {
        console.error("Upload error:", error);
    }
}


