import asyncio
import websockets
import json
import time

CDP_WS_URL = "ws://127.0.0.1:60357/devtools/page/EB53B1A27DC673B51CADC6E833D4A91D"

async def get_html(ws, msg_id):
    # Evaluate JS to get full HTML
    message = {
        "id": msg_id,
        "method": "Runtime.evaluate",
        "params": {
            "expression": "document.documentElement.outerHTML",
            "returnByValue": True
        }
    }
    await ws.send(json.dumps(message))
    response = await ws.recv()
    result = json.loads(response)
    html = result.get("result", {}).get("result", {}).get("value", "")
    print(f"\n[HTML at {time.strftime('%H:%M:%S')}]:\n{html[:500]}...\n")  # Print first 500 chars

async def main():
    async with websockets.connect(CDP_WS_URL) as ws:
        msg_id = 1
        while True:
            await get_html(ws, msg_id)
            msg_id += 1
            await asyncio.sleep(1)

asyncio.run(main())
