# app/db/postgress_db.py
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker
from sqlalchemy import create_engine
from sqlalchemy.ext.asyncio import create_async_engine, AsyncSession
from app.core.config import settings

# Async engine for PostgreSQL
async_engine = create_async_engine(
    settings.get_postgres_dsn(),  # Use the method to get DSN
    echo=settings.DB_ECHO,
    future=True,
    pool_pre_ping=True,  # Enable connection health checks
    pool_recycle=300,     # Recycle connections after 5 minutes
)

# Sync engine (for migrations and sync operations)
sync_engine = create_engine(
    settings.get_sync_postgres_dsn(),  # Use the method to get sync DSN
    echo=settings.DB_ECHO,
    pool_pre_ping=True,
    pool_recycle=300,
)

AsyncSessionLocal = sessionmaker(
    async_engine,
    class_=AsyncSession,
    expire_on_commit=False,
    autoflush=False,
    autocommit=False
)

Base = declarative_base()

# Dependency for async database sessions
async def get_async_db():
    async with AsyncSessionLocal() as session:
        try:
            yield session
        except Exception:
            await session.rollback()
            raise
        finally:
            await session.close()