# app/models/sync_models.py
from sqlalchemy import Column, Integer, String, BigInteger, Boolean, DateTime, Text, JSON, ForeignKey
from sqlalchemy.orm import relationship
from sqlalchemy.sql import func
from app.db.postgress_db import Base

class SyncJob(Base):
    __tablename__ = "sync_jobs"
    
    id = Column(Integer, primary_key=True, index=True)
    user_id = Column(Integer, ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    branch_id = Column(Integer, ForeignKey("user_branches.id", ondelete="CASCADE"), nullable=True)
    job_type = Column(String(50), nullable=False)  # full_sync, push_sync, manual_sync
    status = Column(String(50), default="pending")  # pending, running, completed, failed
    trigger_event = Column(String(100))  # webhook, manual, scheduled
    changes_summary = Column(JSON)  # Store summary of changes
    storage_path = Column(Text)  # Path to stored code/archive
    download_url = Column(Text)
    error_message = Column(Text)
    started_at = Column(DateTime(timezone=True), nullable=True)
    completed_at = Column(DateTime(timezone=True), nullable=True)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    
    # Relationships
    user = relationship("User", back_populates="sync_jobs")
    branch = relationship("UserBranch", back_populates="sync_jobs")

class CodeChange(Base):
    __tablename__ = "code_changes"
    
    id = Column(Integer, primary_key=True, index=True)
    sync_job_id = Column(Integer, ForeignKey("sync_jobs.id", ondelete="CASCADE"), nullable=False)
    repo = Column(String(500), nullable=False)  # github.com/owner/repo
    branch = Column(String(255), nullable=False)
    commit_hash = Column(String(255), nullable=False)
    commit_author = Column(String(255))
    commit_timestamp = Column(DateTime(timezone=True))
    commit_message = Column(Text)
    changes_data = Column(JSON)  # Store the structured changes data
    total_files_changed = Column(Integer, default=0)
    files_added = Column(Integer, default=0)
    files_modified = Column(Integer, default=0)
    files_deleted = Column(Integer, default=0)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    
    # Relationships
    sync_job = relationship("SyncJob")