# app/schemas/error_schemas.py
from pydantic import BaseModel
from typing import List, Optional, Dict, Any

class ErrorDetail(BaseModel):
    code: str
    message: str
    field: Optional[str] = None
    value: Optional[Any] = None

class ErrorResponse(BaseModel):
    error: str
    detail: str
    code: Optional[str] = None
    timestamp: str
    trace_id: Optional[str] = None

class ValidationError(BaseModel):
    loc: List[str]
    msg: str
    type: str

class HTTPValidationError(BaseModel):
    detail: List[ValidationError]

# Predefined error responses
class NotFoundError(ErrorResponse):
    error: str = "Not Found"
    code: str = "NOT_FOUND"

class ValidationErrorResponse(ErrorResponse):
    error: str = "Validation Error"
    code: str = "VALIDATION_ERROR"

class UnauthorizedError(ErrorResponse):
    error: str = "Unauthorized"
    code: str = "UNAUTHORIZED"

class ForbiddenError(ErrorResponse):
    error: str = "Forbidden"
    code: str = "FORBIDDEN"

class InternalServerError(ErrorResponse):
    error: str = "Internal Server Error"
    code: str = "INTERNAL_SERVER_ERROR"

class ConflictError(ErrorResponse):
    error: str = "Conflict"
    code: str = "CONFLICT"

class RateLimitError(ErrorResponse):
    error: str = "Rate Limit Exceeded"
    code: str = "RATE_LIMIT_EXCEEDED"