# app/schemas/user_schemas.py
from pydantic import BaseModel, EmailStr, Field
from typing import Optional, List
from datetime import datetime
from app.schemas.common_schemas import PaginationParams, ListResponse

# ===== RESPONSE SCHEMAS =====
class UserResponse(BaseModel):
    id: int
    email: EmailStr
    is_active: bool
    created_at: datetime
    updated_at: Optional[datetime]
    github_username: str
    github_id: int
    github_login_code: Optional[str]


    class Config:
        from_attributes = True



class UserListResponse(ListResponse):
    users: List[UserResponse]