# migrate.py

import os
import subprocess
from pathlib import Path

from app.core.config import settings

ALEMBIC_DIR = Path("alembic")
ALEMBIC_INI = Path("alembic.ini")

DATABASE_URL =settings.get_sync_postgres_dsn()

def init_alembic():
    if not ALEMBIC_DIR.exists() or not ALEMBIC_INI.exists():
        print("📦 Initializing Alembic...")
        subprocess.run(["alembic", "init", "alembic"], check=True)
        print("✅ Alembic initialized.")


        

        # Set sqlalchemy.url in alembic.ini
        with open("alembic.ini", "r") as f:
            lines = f.readlines()
        with open("alembic.ini", "w") as f:
            for line in lines:
                if line.startswith("sqlalchemy.url"):
                    f.write(f"sqlalchemy.url = {DATABASE_URL}\n")
                else:
                    f.write(line)


def make_migration():
    print("🛠  Autogenerating migration script...")
    subprocess.run(["alembic", "revision", "--autogenerate", "-m", "Auto migration"], check=True)


def apply_migration():
    print("⬆️  Applying migration to DB...")
    subprocess.run(["alembic", "upgrade", "head"], check=True)


def main():
    init_alembic()
    make_migration()
    apply_migration()
    print("✅ Database is now up-to-date with models.")


if __name__ == "__main__":
    main()
