
# 🧬 Archaea Repo Sync — Setup & Deployment Guide

This document explains how to set up, migrate, and run the **Archaea Repo Sync** project using **Docker**, **Alembic**, and **uv** (the Python package manager).

---

## 🧩 Prerequisites

Before you begin, make sure you have the following installed:

- **Docker** and **Docker Compose**
- **Git**
- **uv** (Python package manager)
- A valid **`.env`** file (see below)

---

## ⚙️ Environment Variables

Create a `.env` file in the root directory of the project if it doesn’t exist yet.  
Example:

```bash
# .env
DATABASE_URL=postgresql+psycopg2://user:password@db:5432/database_name
APP_ENV=production
SECRET_KEY=your_secret_key
```

Make sure these variables match your environment setup.

---

## 🚀 Getting Started

Follow these steps to set up and run the project.

### 1. Clone the Repository

```bash
git clone https://github.com/your-org/archaea-repo-sync.git
cd archaea-repo-sync
```

### 2. Pull Latest Changes

```bash
git pull
```

### 3. Stop Any Running Containers

If the project is already running, bring it down first:

```bash
docker-compose down
```

---

## 🧱 Database Migrations (Alembic)

Migrations can be run either **automatically** or **manually**.

### 🧭 Automatic Migration (Recommended)

```bash
docker exec -it archaea-repo-sync_web_1 sh -c "cd /app && uv run migrate.py"
```

This script handles migrations internally using Alembic.

### 🧩 Manual Migration Commands

If you prefer running migrations manually:

```bash
# Initialize Alembic (first time only)
uv run alembic init alembic

# Create a new migration
uv run alembic revision --autogenerate -m "your description"

# Apply all migrations
uv run alembic upgrade head

# Roll back the last migration
uv run alembic downgrade -1

# Show current migration revision
uv run alembic current

# Show full migration history
uv run alembic history

# Show available migration heads
uv run alembic heads
```

Migration scripts are stored in:

```
alembic/versions/
```

---

## 🐳 Running the Application

After handling migrations, build and start the project:

```bash
docker-compose up -d --build
```

The `-d` flag runs the containers in **detached mode** (in the background).

To view running containers:

```bash
docker ps
```

---

## 📜 Viewing Logs

To see logs for a specific running container:

```bash
docker logs <container_id>
```

Or follow the logs live:

```bash
docker logs -f <container_id>
```

---

## 🧰 Common Commands

| Task | Command |
|------|----------|
| Stop all running containers | `docker-compose down` |
| Rebuild containers | `docker-compose up -d --build` |
| Run migrations | `docker exec -it archaea-repo-sync_web_1 sh -c "cd /app && uv run migrate.py"` |
| Check migration status | `uv run alembic current` |
| Roll back one migration | `uv run alembic downgrade -1` |

---

## 🧾 Notes

- Make sure your `.env` file contains valid credentials and environment configurations.
- The `migrate.py` script should handle all schema updates automatically when executed.
- To apply new migrations after updates, simply rerun the migration command before rebuilding the containers.

---

## ✅ Quick Start Summary

```bash
git pull
docker-compose down
docker exec -it archaea-repo-sync_web_1 sh -c "cd /app && uv run migrate.py"
docker-compose up -d --build
```

---

<!-- **Author:** Archaea Team   -->
**License:** MIT  
**Version:** 1.0.0
