from fastapi.responses import JSONResponse
from typing import Any, Optional

def json_response(
    data: Optional[Any] = None,
    message: str = "Success",
    status_code: int = 200
) -> JSONResponse:
    """
    Standardized JSON response for API endpoints.

    Args:
        data: Optional payload (dict, list, etc.)
        message: Human-readable message
        status_code: HTTP status code

    Returns:
        JSONResponse
    """
    payload = {
        "status": "success" if 200 <= status_code < 300 else "error",
        "status_code":status_code,
        "message": message,
        "data": data,
    }
    return JSONResponse(content=payload, status_code=status_code)
