# app/models/user_models.py
from sqlalchemy import Column, Integer, String, BigInteger, Boolean, DateTime, Text, JSON, ForeignKey, UniqueConstraint
from sqlalchemy.orm import relationship
from sqlalchemy.sql import func
from app.db.postgress_db import Base

class User(Base):
    __tablename__ = "users"
    
    id = Column(Integer, primary_key=True, index=True)
    email = Column(String(255), unique=True, index=True, nullable=False)
    full_name = Column(String(255))
    is_active = Column(Boolean, default=True)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    updated_at = Column(DateTime(timezone=True), onupdate=func.now())
    
    # Relationships
    github_accounts = relationship("UserGitHubAccount", back_populates="user")
    sync_jobs = relationship("SyncJob", back_populates="user")

class UserGitHubAccount(Base):
    __tablename__ = "user_github_accounts"
    
    id = Column(Integer, primary_key=True, index=True)
    user_id = Column(Integer, ForeignKey("users.id", ondelete="CASCADE"), nullable=False)
    github_username = Column(String(255), nullable=False)
    github_id = Column(BigInteger, nullable=False)
    installation_id = Column(BigInteger, unique=True, nullable=False)
    github_login_code = Column(String(255), nullable=True)
    account_type = Column(String(50), default="User")  # User or Organization
    avatar_url = Column(Text)
    html_url = Column(Text)
    is_active = Column(Boolean, default=True)
    permissions = Column(JSON)  # Store GitHub app permissions
    suspended_at = Column(DateTime(timezone=True), nullable=True)
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    updated_at = Column(DateTime(timezone=True), onupdate=func.now())
    
    # Relationships
    user = relationship("User", back_populates="github_accounts")
    repositories = relationship("UserRepository", back_populates="github_account")
    
    # Unique constraint
    __table_args__ = (
        UniqueConstraint('user_id', 'installation_id', name='uq_user_github'),
    )