# app/schemas/health_schemas.py
from pydantic import BaseModel
from typing import List, Optional
from datetime import datetime
from app.schemas.common_schemas import HealthStatus

class AccountHealth(BaseModel):
    github_username: str
    installation_id: int
    is_active: bool
    suspended: bool
    repositories_count: int
    last_updated: Optional[datetime]

class UserHealthResponse(BaseModel):
    user_id: int
    health_status: List[AccountHealth]
    overall_health: HealthStatus

class SystemHealthResponse(BaseModel):
    status: HealthStatus
    timestamp: datetime
    database: bool
    redis: bool
    storage: bool
    github_api: bool
    version: str
    uptime: float

class ServiceStatus(BaseModel):
    service: str
    status: HealthStatus
    response_time: float
    last_check: datetime
    error: Optional[str] = None