# app/schemas/user_schemas.py
from pydantic import BaseModel, EmailStr, Field
from typing import Optional, List
from datetime import datetime
from app.schemas.common_schemas import PaginationParams, ListResponse

# ===== BASE SCHEMAS =====
class UserBase(BaseModel):
    email: EmailStr
    full_name: Optional[str] = Field(None, max_length=255)

# ===== CREATE/UPDATE SCHEMAS =====
class UserCreate(UserBase):
    is_active: bool = True

class UserUpdate(BaseModel):
    email: Optional[EmailStr] = None
    full_name: Optional[str] = Field(None, max_length=255)
    is_active: Optional[bool] = None

# ===== RESPONSE SCHEMAS =====
class UserResponse(BaseModel):
    id: int
    email: EmailStr
    full_name: Optional[str]
    is_active: bool
    created_at: datetime
    updated_at: Optional[datetime]

    class Config:
        from_attributes = True

class UserCreateResponse(BaseModel):
    message: str
    user_id: int
    email: EmailStr

class UserListResponse(ListResponse):
    users: List[UserResponse]