# app/schemas/webhook_schemas.py
from pydantic import BaseModel, Field
from typing import Optional, List, Dict, Any
from datetime import datetime
from enum import Enum

class WebhookEventType(str, Enum):
    PUSH = "push"
    INSTALLATION = "installation"
    PING = "ping"
    REPOSITORY = "repository"
    PULL_REQUEST = "pull_request"

class WebhookStatus(str, Enum):
    RECEIVED = "received"
    PROCESSED = "processed"
    FAILED = "failed"

class WebhookPayload(BaseModel):
    event: str
    installation: Optional[Dict[str, Any]] = None
    repository: Optional[Dict[str, Any]] = None
    sender: Optional[Dict[str, Any]] = None
    action: Optional[str] = None
    ref: Optional[str] = None
    before: Optional[str] = None
    after: Optional[str] = None
    commits: Optional[List[Dict[str, Any]]] = None

class WebhookCreate(BaseModel):
    repository_id: Optional[int] = None
    webhook_id: int = Field(..., gt=0)
    event_type: WebhookEventType
    payload: Dict[str, Any]
    headers: Dict[str, Any]
    delivery_id: str
    signature: str
    status: WebhookStatus = WebhookStatus.RECEIVED

class WebhookResponse(BaseModel):
    id: int
    repository_id: Optional[int]
    webhook_id: int
    event_type: WebhookEventType
    status: WebhookStatus
    delivery_id: str
    signature: str
    processed_at: Optional[datetime]
    created_at: datetime

    class Config:
        from_attributes = True

class WebhookListResponse(BaseModel):
    user_id:int
    total_count: int
    webhooks: List[WebhookResponse]

class WebhookProcessingResponse(BaseModel):
    status: str
    event: str
    webhook_id: int
    username: str
    actions_performed: List[str]